function y=FVcdf(xv,par,var,parmatch);
% vector version

[l,a,lambda,jcr,sigma]=expandpar(par);
[Rv,Tv,Sv,vv,thetav]=expandvar(var);

y = zeros(length(xv),1);
uv = u(par,var,parmatch);

for i=1:length(xv);
    x = xv(i);
    T = Tv(i);
    S = Sv(i);
    v = vv(i);
    ui = uv(i);
    theta = thetav(i);
    yi = 0;

    yi(x<=T) = 0;

    yi(x>T & x<=S) = ( Fcdf(x,par)-Fcdf(T,par) )/(lambda*v)/ ...
                ( l+theta*a*q(theta,parmatch)+lambda+q(theta,parmatch) )* ...
                ( (l+a*theta*q(theta,parmatch))*(lambda*(1-ui)+jcr+lambda*v) + ...
                    lambda*(jcr+lambda*v) );

    yi(x>S & x<=sigma) = 1 - (1-Fcdf(x,par))/( lambda*v*(l+q(theta,parmatch)+lambda) )* ...
                                        ( lambda*l*(1-ui)+(jcr+lambda*v)*(l+lambda) );

    y(x>sigma) = 1;
    y(i) = yi;
end;

